using System;
using System.Windows.Forms;
using DicomObjects;
using DicomObjects.EventArguments;

namespace MPPS
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : Form
	{
		internal CheckBox EnableLog;
		internal TextBox Logger;
		internal Label Label1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		private DicomServer Server;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.EnableLog = new CheckBox();
			this.Logger = new TextBox();
			this.Label1 = new Label();
			this.SuspendLayout();
			// 
			// EnableLog
			// 
			this.EnableLog.Checked = true;
			this.EnableLog.CheckState = CheckState.Checked;
			this.EnableLog.Location = new System.Drawing.Point(12, 107);
			this.EnableLog.Name = "EnableLog";
			this.EnableLog.Size = new System.Drawing.Size(160, 24);
			this.EnableLog.TabIndex = 5;
			this.EnableLog.Text = "Enable Live Log";
			// 
			// Logger
			// 
			this.Logger.Location = new System.Drawing.Point(12, 139);
			this.Logger.Multiline = true;
			this.Logger.Name = "Logger";
			this.Logger.ScrollBars = ScrollBars.Vertical;
			this.Logger.Size = new System.Drawing.Size(408, 168);
			this.Logger.TabIndex = 4;
			this.Logger.Text = "";
			// 
			// Label1
			// 
			this.Label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 10F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Label1.Location = new System.Drawing.Point(4, 11);
			this.Label1.Name = "Label1";
			this.Label1.Size = new System.Drawing.Size(432, 96);
			this.Label1.TabIndex = 3;
			this.Label1.Text = @"This is a trivial MPPS SCP, which merely displays the data it receives, and send appropriate responses to the SCU.  In a ""real"" application, the data received through N-CREATE and N-SET operations would normally be used to make equivalent Create and Set operations in a database of performed procedures.";
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(440, 318);
			this.Controls.Add(this.EnableLog);
			this.Controls.Add(this.Logger);
			this.Controls.Add(this.Label1);
			this.Name = "Form1";
			this.Text = "MPPS SCP Sample";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.Form1_Closing);
			this.Load += new System.EventHandler(this.Form1_Load);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		delegate void SetTextCallback(TextBox box, string text);

		private void AppendText(TextBox box, string text)
		{
			// InvokeRequired required compares the thread ID of the
			// calling thread to the thread ID of the creating thread.
			// If these threads are different, it returns true.
			if (box.InvokeRequired)
			{
				SetTextCallback d = AppendText;
				Invoke(d, new object[] { box, text });
			}
			else
			{
				box.Text = box.Text + text + "\r\n";
			}
		}

		private void Form1_Load(object sender, EventArgs e)
		{
			Server = new DicomServer();
			try
			{
				Server.Listen(104);
			}
			catch(DicomException ex)
			{
				AppendText(Logger, ex.Message);
			}
			
			// Put the following line back to enable DicomObjects Logging
			// DicomGlobal.LogToFile("c:\\dicom log files", 63);

			DicomGlobal.LogEvent +=DicomGlobal_LogEvent;                
			DicomGlobal.EventLogLevel = (DicomObjects.Enums.LogLevel) 0x3F;
			Server.NormalisedReceived +=Server_NormalisedReceived;                
		}

		private void DicomGlobal_LogEvent(LogEventArgs e)
		{
			if(EnableLog.Checked)
			{
				AppendText(Logger, e.Text);
			}
		}

		private void Server_NormalisedReceived(object sender, NormalisedReceivedArgs e)
		{
			if(e.Operation == DicomObjects.Enums.DicomOperation.N_CREATE || e.Operation == DicomObjects.Enums.DicomOperation.N_SET)
			{
				e.Status = 0;
			}
			else
			{
				e.Status = 0xC001; // General Error
			}
		}

		private void Form1_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			Server.UnlistenAll();
		}
	}
}
